/*******************************************************}
{                                                       }
{               Borland DB Web                          }
{           Data aware Web controls                     }
{ Copyright (c) 2003, 2005 Borland Software Corporation }
{                                                       }
{*******************************************************/

using System;
using System.Data;
using System.IO;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Collections;
using System.Collections.Specialized;
using System.ComponentModel;
using System.ComponentModel.Design;
using System.ComponentModel.Design.Serialization;
using System.Drawing;
using System.Drawing.Design;
using System.Text;


namespace Borland.Data.Web
{

	#region DBWebVideo

	/// <summary>
	/// Data aware Image control for use with DBWebDataSource
	/// </summary>

	public enum ClipStartMode
	{
		ePageOpen,
		eMouseOver
	}

	[DefaultProperty("Text"),
	Designer("Borland.Data.Web.DBWebControlDesigner"),
	ToolboxBitmap(typeof(Borland.Data.Web.DBWebVideo),
	"Borland.Data.Web.DBWebVideo.bmp"),
	ToolboxData("<{0}:DBWebVideo runat=server></{0}:DBWebVideo>")]
	public class DBWebVideo : WebControl, IDBWebColumnLink, IPostBackDataHandler
	{
		const string TempFile = "_BrlndSnd";
		const string mpgExt      = ".mpg";
		const string mpegExt      = ".mpeg";
		const string aviExt      = ".avi";
		private string SoundUrl;
		private string physicalMoveFile;
		private bool FUseCacheFile;
		private DBWebColumnLink ColumnLink;
		private IDBWebColumnLink IColumnLink;
		private bool bTempFileNameSet;
		private string FExtension;
		private System.Web.UI.WebControls.Panel FPanel;
		private int FLoops;
		private ClipStartMode FStartMode;
		private string FAlternateText;

		public DBWebVideo(): base()
		{
			FUseCacheFile = false;
			ColumnLink = new DBWebColumnLink(this);
			IColumnLink = (ColumnLink as IDBWebColumnLink);
			bTempFileNameSet = false;
			FExtension = mpgExt;
			FPanel = new System.Web.UI.WebControls.Panel();
			FLoops = -1;
			FStartMode = ClipStartMode.ePageOpen;
			FAlternateText = null;
		}

		protected override void OnInit(EventArgs e)
		{
			base.OnInit(e);
			if( Page != null )
				Page.RegisterRequiresPostBack(this);
		}

		public override void Dispose()
		{
			if( ClassUtils.IsDesignTime(Page) )
				DeleteTempFile();
			base.Dispose();
		}


		#region Layout
		[LocalizableCategoryAttribute("Layout")]
		public override Unit Width
		{
      	get
         {
         	return base.Width;
         }
         set
			{
				base.Width = value;
				FPanel.Width = value;
			}
		}


		[LocalizableCategoryAttribute("Layout")]
		public override Unit Height
		{
			get
			{
				return base.Height;
			}
			set
			{
				base.Height = value;
				FPanel.Height = value;
			}
		}
		#endregion

		[LocalizableCategoryAttribute("Video"),
		DefaultValue(-1)]
		[LocalizableDescriptionAttribute("Loops")]
		public int Loops
		{
			get
			{
				return FLoops;
			}
			set
			{
				FLoops = value;
			}
		}
		[LocalizableCategoryAttribute("Video"),
		DefaultValue(ClipStartMode.ePageOpen)]
		[LocalizableDescriptionAttribute("StartMode")]
		public ClipStartMode StartMode
		{
			get
			{
				return FStartMode;
			}
			set
			{
				FStartMode = value;
			}
		}
		[LocalizableCategoryAttribute("Video"),
		DefaultValue(null)]
		[LocalizableDescriptionAttribute("AlternateText")]
		public string AlternateText
		{
			get
			{
				return FAlternateText;
			}
			set
			{
				FAlternateText = value;
			}
		}

		// figure out what the physical image file name should be,
		// and also what the url should be for that filename.
		protected void SetUrlAndFileName(int ImageIndex)
		{
			// get Unique temp file Name for designtime image
			string sPath;
			string fileName;
			if( ClassUtils.IsDesignTime(Page) )
			{
         	sPath = Directory.GetCurrentDirectory() + "\\";
         	fileName = TempFile + this.ID;
         }
         else  // at runtime, use Session.SessionID
         {
            Object oParentRow = Page.Session[ClassUtils.GetPageName(Page) + TableName + DBWebConst.sParentRow];
            string sParentRow = "_";
            if( oParentRow != null )
            {
            	int iParentRow = Convert.ToInt32(oParentRow);
               if( iParentRow >= 0 )
            		sParentRow = Convert.ToString(iParentRow) + "_";
            }
            sPath = Page.Request.PhysicalApplicationPath;
			fileName = TempFile + this.ID + Convert.ToString(Page.Session.SessionID) +
            				sParentRow + Convert.ToString(ImageIndex);;
            object lastFile = Page.Session[this.ID + DBWebConst.sBorlandImageFile];
            if( lastFile != null )
            	DeleteFile(Convert.ToString(lastFile) );
         }
         int iFileIndex = 1;
         physicalMoveFile = fileName;
      	while( File.Exists(sPath + physicalMoveFile) )
			{
         	{  // if DeleteFile fails, increment the FileIndex
            	if(! DeleteFile(sPath + physicalMoveFile) )
               {
		         	physicalMoveFile = fileName + Convert.ToString(iFileIndex);
   		         iFileIndex++;
               }
            }
         }
         if( ClassUtils.IsDesignTime(Page) )
			{
				// at design time, aspx editor won't allow for "file:///c:...."
				if( sPath.IndexOf(':') == 1  )
					SoundUrl = "file:///" + sPath.Substring(3) + physicalMoveFile;
				else
					SoundUrl = "file:///" + sPath + physicalMoveFile;
            physicalMoveFile = sPath + physicalMoveFile;
         }
         else
         {
         	SoundUrl = "http://" + Page.Request.Url.Host + Page.Request.ApplicationPath + "/" + physicalMoveFile;
            physicalMoveFile = sPath + physicalMoveFile;
            Page.Session[this.ID + DBWebConst.sBorlandImageFile] = physicalMoveFile;
         }
         bTempFileNameSet = true;
      }

      #region IDBWebDataLink
      string IDBWebDataLink.TableName
      {
      	get
         {
         	return IColumnLink.TableName;
         }
         set
         {
         	IColumnLink.TableName = value;
         }
      }
      IDBDataSource IDBWebDataLink.DBDataSource
      {
      	get
         {
         	return IColumnLink.DBDataSource;
         }
         set
         {
         	IColumnLink.DBDataSource = value;
         }
      }
      #endregion
      #region IDBWebColumnLink
      string IDBWebColumnLink.ColumnName
      {
      	get
         {
         	return IColumnLink.ColumnName;
         }
         set
         {
            if( !ClassUtils.SameValue(IColumnLink.ColumnName, value ) )
               DeleteTempFile();
         	IColumnLink.ColumnName = value;
         }
      }
      #endregion

      [Editor(typeof(Borland.Data.Web.TableNamePropEditor), typeof(UITypeEditor)),
		LocalizableCategoryAttribute(DBTypes.sDBWebControl),
		DefaultValue(null)]
		[LocalizableDescriptionAttribute("TableName")]
      public string TableName
      {
      	get
         {
	      	return IColumnLink.TableName;
         }
      	set
         {
            if( !ClassUtils.SameValue(IColumnLink.TableName, value ) )
               DeleteTempFile();
	      	IColumnLink.TableName = value;
         }
      }
		[LocalizableCategoryAttribute(DBTypes.sDBWebControl),
		DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden),
		DefaultValue(null)]
		[LocalizableDescriptionAttribute("DataSource")]
      public IDBDataSource DBDataSource
      {
      	get
         {
         	return IColumnLink.DBDataSource;
         }
         set
         {
         	IColumnLink.DBDataSource = value;
         }
      }


		[LocalizableCategoryAttribute(DBTypes.sDBWebControl),
      Editor(typeof(Borland.Data.Web.ImageColumnPropEditor), typeof(UITypeEditor)),
		DefaultValue(null)]
		[LocalizableDescriptionAttribute("ColumnName")]
      public string ColumnName
      {
      	get
         {
         	return IColumnLink.ColumnName;
         }
         set
         {
         	IColumnLink.ColumnName = value;
         }
      }
		[LocalizableCategoryAttribute(DBTypes.sDBWebControl),
      DefaultValue(false)]
		[LocalizableDescriptionAttribute("UseCacheFile")]
      public bool UseCacheFile
      {
      	get
         {
         	return FUseCacheFile;
         }
         set
         {
         	FUseCacheFile = value;
         }
      }

      #region IPostBackDataHandler
      // RaisePostDataChangedEvent is called prior to DataBind()
      // DataSet and related properties are NOT available here
      // Child controls are not available
		bool IPostBackDataHandler.LoadPostData(string postDataKey,
			NameValueCollection postCollection)
      {
         if( this.Visible )
	      	ColumnLink.LoadPostData(postDataKey, postCollection);
         return false;
      }

	   void IPostBackDataHandler.RaisePostDataChangedEvent()
   	{
	   }
      #endregion

		protected override void OnPreRender(EventArgs args)
		{
			base.OnPreRender(args);
			bool IsPostBack = !ClassUtils.IsDesignTime(Page) && Page.IsPostBack;
         if( !IsPostBack )
         	DeleteTempFiles();
			string s = Page.Request.QueryString[DBWebConst.sBorlandImageID];
         if( s != null && s == this.ID )
         {
				Object o = Page.Session["Snd_" + this.ID];
				Page.Response.BinaryWrite((byte[])o);
            Page.Response.End();
         }
         else
         {
            DataBind();
         }
		}

      // design-time or FUseCacheFile is true;
      protected void CreateImageFile(byte[] byteBlobData)
      {
         bool bFileInUse = false;
      	if( ClassUtils.IsDesignTime(Page) || FUseCacheFile )
         {
	         if( File.Exists(physicalMoveFile) )
   	      {
      	   	try
         	   {
            		File.Delete(physicalMoveFile);
	            }
   	         catch
      	      {
         	   	// ignore error if file is in use by the IDE
            	   bFileInUse = true;
					}
				}
         }
         if( !bFileInUse )
         {
         	FileStream s = File.Create(physicalMoveFile);
            try
            {
					int bytes = byteBlobData.Length;
               s.Write(byteBlobData, 0, bytes);
            }
            finally
            {
            	s.Close();
            }
         }
      }


		protected byte[] GetSound( DataRow row )
		{
			if( row != null )
			{
				if( ! row.IsNull(IColumnLink.ColumnName) )
				{
					Byte[] byteBlobData = new Byte[0];
					try
					{
						byteBlobData = (Byte[])row[IColumnLink.ColumnName];
						return byteBlobData;
					}
					catch
					{
						return null;
					}
				}
			}
			return null;
      }

		protected override void Render(HtmlTextWriter output)
		{
			bool error = ClassUtils.OutputErrors(Page, output, IColumnLink);
			if( !error || (IColumnLink.DBDataSource as DBWebDataSource).ErrorOption != ErrorHtmlOption.logOnErrorPage )
			{
				output.Write(Text);
			}
			else  // if going to a separate error hmtl page, output "OK" button.
			{
				ClassUtils.OutputOKButton(output);
				Page.Response.End();
			}
		}

		public override void DataBind()
		{
			try
			{
				if( !ClassUtils.IsDesignTime(Page) )
					Page.Session.Remove("Snd_" + this.ID);
				base.DataBind();
				if( ColumnLink.IsDataBound )
				{
					Type type;
					Object thisObject = IColumnLink.DBDataSource.GetColumnValue(Page,
										IColumnLink.TableName, IColumnLink.ColumnName, out type);
					if( thisObject == null )
						SoundUrl = "";
					else if( type == Type.GetType(TypeLiterals.SystemString) )
					{
						SoundUrl = Convert.ToString(thisObject);
					}
					else
					{
						Byte[] byteBlobData = null;
						try
						{
							byteBlobData = ((Byte[]) thisObject);
						}
						catch( Exception ex )
						{  // GetType() has failed to calculate String FieldType
							byteBlobData = null;
						}
						if( byteBlobData != null )
						{
							if( ClassUtils.IsDesignTime(Page) || FUseCacheFile )
							{
								int ImageIndex = 0;
								if( !ClassUtils.IsDesignTime(Page) )
								{
									String PageName = ClassUtils.GetPageName(Page);
									object o = Page.Session[PageName + TableName + DBWebConst.sImageIndex];
									if( o != null )
										ImageIndex = Convert.ToInt32(o) + 1;
									Page.Session[PageName + TableName + DBWebConst.sImageIndex] = ImageIndex;
								}
								SetUrlAndFileName(ImageIndex);
								CreateImageFile(byteBlobData);
							}
							else
							{
								Page.Session["Snd_" + this.ID] = byteBlobData;
								SoundUrl = "http://" + Page.Request.Url.Host +
										Page.Request.Url.AbsolutePath + "?" + DBWebConst.sBorlandImageID + "=" + this.ID;  // { do not localize}
							}
						}
					}
					base.DataBind();
				}
				ChildControlsCreated = true;
				ClassUtils.SetSizeProperties( FPanel, this );
				ClassUtils.SetOuterAppearanceProperties( FPanel, this );
			}
			catch(Exception ex)
			{
				if( !ClassUtils.IsDesignTime(Page) )
				{
					Page.Response.Write(ClassUtils.GetInternalError(Page, IColumnLink, ex, this.ID));
				}
				else
					throw new Exception(ex.Message);
			}
		}


		private bool DeleteFile(string fileName)

      {

      	try

         {

         	if( File.Exists(fileName) )

            	File.Delete(fileName);

            return true;

         }

         catch

         {

         	// ignore file in use exceptions

         }

			return false;

		}


		private void DeleteTempFile()

		{

			if( ClassUtils.IsDesignTime(Page) )

				DeleteFile(physicalMoveFile);

		}


		private void DeleteTempFiles()

      {

      	DirectoryInfo de = new DirectoryInfo(Page.Request.PhysicalApplicationPath);

         FileInfo[] files = de.GetFiles(TempFile + this.ID + "*");

         foreach( FileInfo file in files )

	      	DeleteFile(file.FullName);

   	}


		protected string Text

		{
			get
			{
				string height = "";
				string width = "";
				string start;
				string loop;
				if( this.Width.Value > 0 )
					width = "width=\"" + Convert.ToInt32(this.Width.Value) + "\"";
				if( this.Height.Value > 0 )
					height = "height=\"" + Convert.ToInt32(this.Height.Value) + "\"";
				string alternatetext = "";
				if( !ClassUtils.IsEmpty(FAlternateText) )
					alternatetext = " ALT=\"" + FAlternateText + "\"";
				loop = " loop=\"" + Convert.ToInt32(FLoops) + "\"";
				if( FStartMode == ClipStartMode.ePageOpen )
					start = " start=\"FILEOPEN\"";
				else
					start = " start=\"MOUSEOVER\"";
				StringWriter sw = new StringWriter();
				HtmlTextWriter tw = new HtmlTextWriter(sw);
				DataBind();
				ClassUtils.AddStyleToWebControl(FPanel, this.Style);
				FPanel.RenderBeginTag(tw);
				tw.Write("<image dynsrc=\"" + SoundUrl + "\""  + loop + start + width + height + alternatetext + "></image>");
				FPanel.RenderEndTag(tw);
				return sw.ToString();
			}
		}


	}
	#endregion
}

